//=============================================================================
// This is the superclass of all driveable cars, made by WCCC
//=============================================================================
class MSDrivables extends Vehicles;

var DeusExPlayer MSCarDriver;
var float MSCarSpeed;

function Frob(Actor Frobber, Inventory frobWith)
{
  local DeusExPlayer player;

  player = DeusExPlayer(Frobber);

  if ((player != None) && (MSCarDriver == None))
  {
    player.SetLocation(Self.Location - vect(0,0,1) * CollisionHeight / 2);
    MSCarDriver = player;
    bBlockPlayers = False;
//    MSCarDriver.bBehindview = True;
    return;
  }
  if ((player != None) && (MSCarDriver != None))
  {
    MSCarDriver.SetLocation(Self.Location + vect(0,0,1) * (CollisionHeight / 2 + MSCarDriver.CollisionHeight + 48)); 
//    MSCarDriver.bBehindView = False;
    MSCarDriver = None; 
    bBlockPlayers = True;
    SetPhysics(PHYS_Falling); //added because the car floats in the air otherwise...
    return;   
  }
}

function Tick(float Deltatime)
{
  local Actor Other;

  if (MSCarDriver != None)
  {
    SetLocation(MSCarDriver.Location + vect(0,0,1) * CollisionHeight / 2);
// bunch of shitty hack attempts... 
//    Velocity = MSCarDriver.Velocity * 2;
//    Acceleration = MSCarDriver.Acceleration * 2;
//    Acceleration = Normal(MSCarDriver.Velocity * 2);
    SetRotation(MSCarDriver.Rotation);
//a little calculation to measure how fast the car is going, used for damage calculation.
    MSCarSpeed = (MSCarDriver.Location.X - MSCarDriver.OldLocation.X) + (MSCarDriver.Location.Y - MSCarDriver.OldLocation.Y);
    CheckForRoadKill(Other);
  }  
}

function CheckForRoadKill(Actor Other)
{
  ForEach VisibleActors(class'Actor',Other,CollisionRadius + 5,Location)
  {
    if ((Other != None) && (Other != MSCarDriver) && (MSCarSpeed > 0))
    {
      Other.TakeDamage(MSCarSpeed, MSCarDriver, Other.Location, Normal(MSCarDriver.Velocity) * 2000, 'Exploded');
    }
  }
}

defaultproperties
{
     MSCarDriver=None
     bCanBeBase=True
     bBlockActors=True
}
